package gov.va.med.mhv.usermgmt.integration.service.delegate;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.Collection;

import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientIdentifier;
import gov.va.med.mhv.integration.phr.transfer.RefreshDataParameters;

/**
 * Service delegate for the Patient service
 */
public interface PatientDataServiceDelegate {

    // N.B. - This MUST be namespaced to ensure uniqueness when multiple
    // apps are present
    /**
     * Name which uniquely identifies the PatientIdentity service.
     **/
    public static final String SERVICE_NAME =
        "gov.va.med.mhv.integration.phr.PatientDataService";

    /**
     * Generate a download file, results will be stored in the
     * MHV_DOWNLOAD_REPORT table
     *
     * @param userId   database user id
     * @throws RemoteException
     */
    public void generateDownload(long userId) ;

    /**
     * Generate a download file, results will be stored in the
     * MHV_DOWNLOAD_REPORT table
     *
     * @param userId   database user id
     * @throws RemoteException
     */
    public void generateDownload(long userId, Collection options, Date startDate, Date endDate, long dateSelection, long typeSelection ) ;


    /**
     * Refresh patient data.
     * Calls remote services to request updates according to the refresh
     * policy.
     * @param refreshParameters Must contain icn and a list of stations.
     * @throws Exception
     */
    public void refreshData(RefreshDataParameters refreshParameters);
    /**
     * Retrieve the status of requests for a patient.
     * @param patientID identifier containing icn
     * @return A patient extract status containing their icn, retrieval date
     * and a list of statuses.
     * @throws Exception
     */
    public PatientExtractStatus getStatus(PatientIdentifier patientID);

    /**
     * Remove all data for a facility associated with a patient.
     * @param patientID Identifier containing icn.
     * @param stationNumber
     * @throws RemoteException
     */
    public void removePhrData(PatientIdentifier patientID,
        String stationNumber);


}